/*
		Facility:
			SpatialObjects - Geographic Network Management
	        Copyright 2001 Celeritas Technologies, L.L.C.
			
	 	Title:
	   		ctValidateCommon.js
			
		Abstract:
			This file contains various functions that are common to
			various	validation routines.
	      
	 	Author:
			Robert L. Marshall/Celeritas Technologies, LLC
	
	  	Creation Date:
	 		02-May-2001
	
		Modification History:
			23-Jul-2001		rlm
				Added bDateDefaultEmptyOK, DEFAULT_DATE_FORMAT, and
				DEFAULT_DATE_TIME_FORMAT.
	
		See Also:
			ctValidateTest.html
			ctValidateNumber.js
			ctValidateDate.js
	
		Dependencies:
			None.
*/

/*
	----------------------------------------------------------------------
	The test file for this file is ctValidateTest.html.  If any
	changes are made to the functions in this file, those changes must be
	tested by running the test file.
	----------------------------------------------------------------------
	
	pbEmptyOK:
	Some of the validation functions in the various JavaScript
	validation files provide the optional argument pbEmptyOK.
	If a function provides argument pbEmptyOK, when a call to
	that function is made, if argument pbEmptyOK is not empty, pbEmptyOK
	(set to true or false) is used to set the function's return value
	when psValue (the value being validated) is empty.
	If pbEmptyOK is an empty argument, the appropriate global default
	variable (such as bNumberDefaultEmptyOK, for many of the number
	validation functions in file ctValidateNumber.js) is used to set
	the function's return value.
	
	Global default variable bNumberDefaultEmptyOK (as well as other
	global default variables for the various JavaScript validation
	files) are initialized below.
	
	For the meaning of "empty," see the function isEmpty in this file.	
*/
		//
		// (Default flags in addition to those initialized below
		// should be initialized here as those flags are developed
		// to support future validation functions.)
		//
		// Initialize the default empty OK flag for the number validation
		// functions.
		//
	var bNumberDefaultEmptyOK = false;
		//
		// Initialize the default empty OK flag for the date validation
		// functions.
		//
	var bDateDefaultEmptyOK = false;
		//
		// Initialize the default date format for date functions.
		//
	var DEFAULT_DATE_FORMAT = "MM/dd/yyyy";
		//
		// Initialize the default date (with time) format for date functions.
		//
	var DEFAULT_DATE_TIME_FORMAT = "MM/dd/yyyy HH:mm:ss";

		//
		// This function returns true if the object passed to it is
		// null or of zero length.
		//
		// For the following arguments, the function returns the following:
		// 		null									Returns true
		//		NaN (Not-a-Number)						Returns false
		//		"" (empty string)						Returns true
		//		true (logical value)					Returns false
		//		false (logical value)					Returns false
		//		Infinity (top-level property)			Returns false
		//
	function isEmpty(prObject) {

	   return ((prObject == null) || (prObject.length == 0));
	
	}

