/*

    Facility:
        Celeritas Technologies General (ct)
            Copyright 2001 Celeritas Technologies, LLC

    Title:
        ctPopUpDialog.js

    Abstract:
        This module contains a routine that places a browser window (of
		specified size) on the screen at specified coordinates.  The
		pop-up window either can be enabled to be modal (always visible
		until closed, when the browser provides the modal feature) or
		can be disabled from allowing modal functionality.

	Requires:
		None.	
		
    Author:
        Robert L. Marshall (rlm)
        
    Creation Date:
        09-Feb-2001
        
    Modification History:
		01-Mar-2001	dws
			Added the capability to return a reference to the new window object.
			
		02-Mar-2001	sae
			Added focus to the window object created as the pop-up so that it 
			would not get lost behind other windows of the browser.
			
		12-Mar-2001 rlm
			Added showModalDialog option for displaying the pop-up as
			a modal window.  Moved the focus statement inside the
			non-modal block of code, since it only applies to a
			non-modal pop-up window.
		
		02-Apr-2001 rlm
			Added the parameter prModalArgument to the showPopUp function
			signature to allow a string, numeric, object, or array
			to be passed to a modal window. 
*/

		//
		// For the function showPopUp, default window properties are
		// as follows:
		//		resizable = true,
		//		scrollbars = true,
		//		status bar = false,
		//		use modal = false.
		// To modify these window properties from their defaults, the
		// appropriate Boolean literal (true or false) must be used as
		// an argument in the function call.
		//
		// The top offset (pnTopOffset) and inside width (pnInsideWidth) of
		// the window are set via the function call.  The left coordinate
		// and inside height of the window are modified, as necessary, by
		// the code so that the window fits within the available screen
		// display area.  The constants nMinLeftWindowCoord and
		// nMinWindowHeight impose sensible limits on the left coordinate
		// and inside height calculation results.
		//
		// prModalArgument is valid only when a modal window is to be
		// displayed. prModalArgument specifies the string, numeric,
		// object, or array  that is passed to the modal window and
		// is accessible in the modal window via a statement such as
		// the following:
		// 		var myVariable = window.dialogArguments;
		// If a modal window is not being called, prModalArgument can
		// be set to null.
		//
		// If the object returned by this function is not required by
		// the caller of this function (such as the call being made from
		// within an href statement), the function call within the caller
		// can be formulated as follows:
		// 	href="javascript: var winObj = showPopUp(argument list . . .);"
		// where winObj is a dummy object.
		//
function showPopUp(psPageName, psPageTitle, pnLeftOffset, pnTopOffset,
					pnInsideWidth, pnInsideHeight, pbResizable, pbScrollbars,
					pbStatusBar, pbUseModal, prModalArgument) {

	var nLeftValue;
	var nHeightValue;
	var rWindowObject;				// Window object returned.
	var sResizableValue = "yes";	// Set default to be resizable.
	var sScrollbarsValue = "yes";	// Set default to have scroll bars. 
	var sStatusBarValue = "no";		// Set default not to have status bar.
	var bUseModalValue = false;		// Set default preference not to be modal.

		//
		// Constants to impose sensible limits on the pop up window's
		// properties and display location.
		//
	var nMinLeftWindowCoord = 0;
	var nMinWindowHeight = 100;
		
		
		//		
		// pnInsideWidth is the inside display-area width of the window.
		// 15 pixels are added to pnInsideWidth to account for the right-hand
		// scroll bar.
		//
	if ((pnLeftOffset + (pnInsideWidth + 15)) <= screen.availWidth) {
		nLeftValue = pnLeftOffset;
	} else {
			//
			// Subtracting 30 pixels provides space between the right side of
			// the window and the right border of the browser/screen.
			//
		nLeftValue = screen.availWidth - (pnInsideWidth + 15) - 30;
	}
		//
		// nLeftValue (the screen X coordinate) must be no less than
		// nMinLeftWindowCoord.
		//
	nLeftValue = Math.max(nLeftValue, nMinLeftWindowCoord);

	
		//
		// pnTopOffset is the pixel dimension of the window from the top
		// of the screen.
		// pnInsideHeight is the preferred inside display-area height
		// of the window.
		// 30 pixels are added to pnInsideHeight to account for the window
		// header.
		//
	if ((pnTopOffset + (pnInsideHeight + 30)) <= screen.availHeight) {
		nHeightValue = pnInsideHeight;
	} else {
			//
			// Subtracting 60 pixels provides space between the bottom of
			// the window and the lower border of the browser/screen.
			//
		nHeightValue = screen.availHeight - pnTopOffset - 60;
	}
		//
		// nHeightValue (the inside display-area height of the window)
		// is maintained at a minimum height.
		//
	nHeightValue = Math.max(nHeightValue, nMinWindowHeight);


		//
		// Turn off the resizable property of the pop up window, if
		// so specified in the function call.  The strict equal
		// comparison operator (===) prevents anything but a strict
		// false from changing the default.
		//
	if (pbResizable === false) {
			sResizableValue = "no";
	}

		//
		// Turn off the scrollbars property of the pop up window, if
		// so specified in the function call.  The strict equal
		// comparison operator (===) prevents anything but a strict
		// false from changing the default.
		//
	if (pbScrollbars === false) {
			sScrollbarsValue = "no";
	}

		//
		// Turn on the status bar property of the pop up window, if
		// so specified in the function call.  The strict equal
		// comparison operator (===) prevents anything but a strict
		// true from changing the default.
		//
	if (pbStatusBar === true) {
			sStatusBarValue = "yes";
	}
	

	var sName = navigator.appName;
	var sVer = navigator.appVersion;

		//
		// If the preference is for the pop up window to be modal,
		// verify that the browser supports the function showModalDialog
		// (available for Internet Explorer 4 and later).  The strict
		// equal comparison operator (===) prevents anything but a strict
		// true from changing the default of preferring the window
		// not to be modal.
		//
	if ((pbUseModal === true) && (sName == "Microsoft Internet Explorer") &&
			(sVer.substr(sVer.indexOf("MSIE") + 5, 1) >= 4)) {
			
			//
			// Create the pop up as a modal window.
			//
		rWindowObject = window.showModalDialog(psPageName, prModalArgument,
								"dialogLeft:" + nLeftValue + "px;" +
								"dialogTop:" + pnTopOffset + "px;" +
								"dialogWidth:" + pnInsideWidth + "px;" +
								"dialogHeight:" + nHeightValue + "px;" +
								"resizable:" + sResizableValue + ";" +
								"scroll:" + sScrollbarsValue + ";" +
								"status:" + sStatusBarValue + ";" +
								"maximize:yes;" +
								"minimize:no;" +
								"help:no");
								
	} else {
	
			//
			// Create the pop up as a normal (non-modal) window.
			//
		rWindowObject = window.open(psPageName, psPageTitle,
								"left=" + nLeftValue + "," +
								"top=" + pnTopOffset + "," +
								"width=" + pnInsideWidth + "," +
								"height=" + nHeightValue + "," + 
								"resizable=" + sResizableValue + "," +
								"scrollbars=" + sScrollbarsValue + "," +
								"status=" + sStatusBarValue);
			//						
	    	// Force the window to come back into focus, if it has been pushed 
			// behind some other window.
			//
		rWindowObject.focus();
		
	}

		//
		// If the "if" (window.showModalDialog) block is executed,
		// rWindowObject is the window.returnValue from the modal window
		// (showModalDialog method), which can be specified in the
		// modal window content code in the following manner:
		// 		window.returnValue = myVariable;
		//
		// If the "else" (window.open) block is executed, rWindowObject is
		// a handle to the non-modal opened window.
		//
	return rWindowObject;
		
}


