/*
		Facility:
			SpatialObjects - Geographic Network Management
	        Copyright 2001 Celeritas Technologies, L.L.C.
			
	 	Title:
	   		ctNumberValidation.js
			
		Abstract:
			This file contains various functions that provide
			validation of numbers.
	      
	 	Author:
			Robert L. Marshall/Celeritas Technologies, LLC
	
	  	Creation Date:
	 		05-Apr-2001
	
		Modification History:
			dd-mmm-yyyy	(iii)
	
		Dependencies:
			None.
*/

		//
		// This function receives an object and returns true if it is
		// in hexadecimal number format.  For the object to be in
		// hexadecimal number format, it must consist of character
		// digits, where each character digit must be one of the following:
		// 		0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
		//		A, B, C, D, E, F,
		//		a, b, c, d, e, f
		// 
		// For the following objects, the function returns the following:
		// 		null									Returns false
		//		NaN (Not-a-Number)						Returns false
		//		"" (empty string)						Returns false
		//		true (logical value)					Returns false
		//		false (logical value)					Returns false
		//		Infinity (top-level property)			Returns false
		//
	function isHexNumberFormat(prObject) {
		if (prObject != null && prObject.length != 0) {
			
			var sChar;
			var sString = prObject.toString().toUpperCase();
	
			for (var nCharIndex = 0; nCharIndex < sString.length;
					nCharIndex++) {

				sChar = sString.charAt(nCharIndex);
				if ((sChar < '0') || (sChar > '9' && sChar < 'A') ||
						(sChar > 'F')) {
					return false;
				}	
			}
			return true;
			
		} else {
		
			return false;
			
		}
	}


	
		//
		// This function receives an object and returns true if it is
		// zero or a positive decimal integer.  For the object to be zero
		// or a positive decimal integer, it must consist of character
		// digits, where each character digit must be one of the following:
		// 		0, 1, 2, 3, 4, 5, 6, 7, 8, 9
		//
		// If the object contains a leading '+', this function
		// returns false.
		//
		// This function evaluates correctly regardless of whether
		// the object has one or more leading zeros.
		//
		// For the following objects, the function returns the following:
		// 		null									Returns false
		//		NaN (Not-a-Number)						Returns false
		//		"" (empty string)						Returns false
		//		true (logical value)					Returns false
		//		false (logical value)					Returns false
		//		Infinity (top-level property)			Returns false
		//
	function isZeroPosInteger(prObject) {
		if (prObject != null && prObject.length != 0) {
			
			var sChar;
			var sString = prObject.toString();

			for (var nCharIndex = 0; nCharIndex < sString.length;
					nCharIndex++) {

				sChar = sString.charAt(nCharIndex);
				if (sChar < '0' || sChar > '9') {
					return false;
				}	
			}
			return true;
			
		} else {
		
			return false;
			
		}
	}	
	

		//
		// This function receives an object and returns true if it is
		// zero or a positive decimal integer within the range specified
		// by pnMinValue and pnMaxValue inclusive.
		//
		// See the function isZeroPosInteger for a description of
		// that function's requirements.
		//
	function isZeroPosIntegerInRange(prObject, pnMinValue, pnMaxValue) {
	
		if (isZeroPosInteger(prObject)) {
				//
			    // Check minimum
				//
		    if (pnMinValue != null) {

		        if (parseInt(prObject, 10) < pnMinValue) {
					return false;
				}
			}
		
				//
			    // Check maximum
				//
		    if (pnMaxValue != null) {

				if (parseInt(prObject, 10) > pnMaxValue) {
					return false;
				}
			}
			
		    return true;

		} else {
		
			return false;
			
		}
	}


