/*
		Facility:
			SpatialObjects - Geographic Network Management
	        Copyright 2001 Celeritas Technologies, L.L.C.
			
	 	Title:
	   		ctMathFunctions.js
			
		Abstract:
			This file ccontains various math functions.
	      
	 	Author:
			Robert L. Marshall/Celeritas Technologies, LLC
	
	  	Creation Date:
	 		16-Mar-2001
	
		Modification History:
			dd-mmm-yyyy	(iii)
	
		Dependencies:
			None.
*/

		//
		// This function receives a decimal integer (0 through 15) as
		// an argument and returns its hexadecimal form (0 through F).
		// A floating point number that is exactly integral (0.0, 1.0,
		// 2.0, . . . , 15.0) is considered to be a decimal integer.
		//
		// For other arguments, the function returns the following:
		// 		null									Returns null
		//		NaN (Not-a-Number)						Returns null
		//		"" (empty string)						Returns 0
		//		true (logical value)					Returns 1
		//		false (logical value)					Returns 0
		//		"text" (non-empty text string)			Returns null
		//		Infinity (top-level property)			Returns null
		//		Integers left-padded with zero(s)		Returns correct result
		//		Numbers less than 0 or greater than 15	Returns null
		//		Float numbers not exactly integral		Returns null
		//
	function changeDecToHexForm(pnDigit) {
			//
			// Check validity of the number being passed to this function.
			//
		if (Math.floor(pnDigit) == pnDigit && (pnDigit >= 0 && pnDigit <= 15)) {

			var sHexDigit = "";
			if (pnDigit >= 0 && pnDigit <= 9) {

				return sHexDigit += Math.floor(pnDigit);
				
			} else if (pnDigit >= 10 && pnDigit <= 15) {
			
				if     (pnDigit == 10) {return sHexDigit += "A";}
				else if(pnDigit == 11) {return sHexDigit += "B";}
				else if(pnDigit == 12) {return sHexDigit += "C";}
				else if(pnDigit == 13) {return sHexDigit += "D";}
				else if(pnDigit == 14) {return sHexDigit += "E";}
				else if(pnDigit == 15) {return sHexDigit += "F";}
			}
			
		} else {
		
			return null;
			
		}
	}


	
		//
		// This function receives a decimal integer (0 or greater) as
		// an argument and returns its hexadecimal form.  The second
		// argument (pnMinHexDigits) is an optional decimal integer that
		// specifies the desired number of digits to be returned in
		// the return string (via padding the hex number with zeros
		// on the left).
		// A floating point number that is exactly integral (0.0, 1.0,
		// 2.0, . . . ) is considered to be a decimal integer.
		//
		// If pnDecNum is not a decimal integer, the function returns
		// as follows:
		// 		null									Returns null
		//		NaN (Not-a-Number)						Returns null
		//		"" (empty string)						Returns 0
		//		true (logical value)					Returns 1
		//		false (logical value)					Returns 0
		//		"text" (non-empty text string)			Returns null
		//		Integers left-padded with zero			Returns correct result
		//		Numbers less than 0						Returns null
		//		Float numbers not exactly integral		Returns null
		//
	function changeDecToHex(pnDecNum, pnMinHexDigits) {	
			//
			// Check validity of the number being passed to this function.
			//
		if (Math.floor(pnDecNum) == pnDecNum && pnDecNum >= 0) {
		
				// If the number of hexadecimal digits requested
				// for the output string is an integer greater than
				// or equal to 1, set the nMinHexDigits variable
				// equal to the requested number.  Otherwise,
				// set nMinHexDigits equal to 1).
			var nMinHexDigits = 1;
			if (pnMinHexDigits != null &&
					(Math.floor(pnMinHexDigits) == pnMinHexDigits &&
					pnMinHexDigits > 1)) {
				nMinHexDigits = Math.floor(pnMinHexDigits);
			}	
				//
				// Determine the number of hexadecimal digits required
				// to represent the decimal integer (not including any
				// left-padding with zeros).
				//
			var nDecNumTemp = pnDecNum;
			for (var nNumHexDigits = 1;
					Math.pow(16, (nNumHexDigits)) <= nDecNumTemp;
					++nNumHexDigits) {
			}		
				//
				// Determine each hexadecimal digit's value, and
				// sequentially append each digit onto the output string.
				//
			var sHexStr = "";	
			nDecNumTemp = pnDecNum;								
			var nThisHexDigit = 0;
			
			for (var nExp = (nNumHexDigits - 1); nExp >= 0; nExp--) {
				nThisHexDigit = Math.floor(nDecNumTemp/Math.pow(16, nExp));
				sHexStr += changeDecToHexForm(nThisHexDigit);
				nDecNumTemp -= (Math.pow(16, nExp) * nThisHexDigit);
			}
				//
				// If the output string is not equal to null, and if
				// the number of hex digits requested for the output
				// string is greater than the number of digits required
				// to represent the decimal integer in hex, left-pad
				// the output string with the necessary number of zeros.
				//
			if (sHexStr != null && nMinHexDigits > nNumHexDigits) {
				var sPadStr = "";
				var nNumPad = nMinHexDigits - nNumHexDigits;
				for (var nPadCount = 1;	nPadCount <= nNumPad; nPadCount++) {
					sPadStr += "0";
				}
				sHexStr = sPadStr + sHexStr;
			}

			return sHexStr;
	
		} else {
	
			return null;
			
		}
	}	