/*

    Facility:
        Celeritas Technologies General (ct)
            Copyright 1999 Celeritas Technologies, LLC

    Title:
        ctListCommon

    Abstract:
        This module contains a collection of common Javascript list functions.

    Author:
        Scott A. Evans (sae)
        
    Creation Date:
        28-Nov-1999
        
    Modification History:
        dd-mmm-yyyy (iii)
            Description of change.

*/
    // List Object: constructor.
function List( size ) {
    
    this.listObj   = new Array(size);
    this.addAll    = _listAddAll;
    this.getAt     = _listGetAt;
    this.getSize   = _listGetSize;
    this.isEmpty   = _listIsEmpty;
    this.removeAll = _listRemoveAll;
    this.initSize  = size;
    this.size      = 0;
    
}

    // List Object: addAll.
function _listAddAll( listString, delimChar ) {
    var listObj = this.listObj;
    var listEnd;
    var tmpStr;

        // Set the initial size of the list to zero (no elements in the list).
    var listSize = 0;
        
        // Break out all elements in the list.  Elements are defined as all 
        // characters between delimChars or between the beggining or end and
        // a delimChar.
    var lstStr = listString;
    var listStart = 0;
    var listEnd = lstStr.indexOf(delimChar);
    
    while ( listEnd > listStart ) {
        if ( listEnd > 0 ) {
            tmpStr = lstStr.substring(listStart, listEnd);
            //lstStr = lstStr.substr(++listEnd);
        }
        else {
            tmpStr = lstStr.substr(listStart);
            listStart = lstStr.length;
        }
        listObj[listSize++] = tmpStr;
        listStart = listEnd + 1;
        listEnd = lstStr.indexOf(delimChar, listStart);
    }

        // Grab the last element of the list.
    if ( listStart < lstStr.length ) {
        listObj[listSize++] = lstStr.substring(listStart);
    }
    
    this.size = listSize;
}

    // List Object: removeAll.
function _listRemoveAll() {
    this.size = 0;
    this.listObj = null;
}

    // List Object: getSize.
function _listGetSize() {
    return this.size;
}

    // List Object: getAt.
function _listGetAt(index) {
    return this.listObj[index];
}

    // List Object: addAll.
function _listIsEmpty() {
    return !(this.size > 0);
}