/*

    Facility:
        Celeritas Technologies General (ct)
            Copyright 1999-2002 CeleritasWorks, LLC

    Title:
        ctLayerCommon

    Abstract:
        This module contains a collection of common Javascript functions that 
        facilitate cross browser layer management.

        Requires: ctBrowserSensing.js
        
    Author:
        Celeritas Technologies
        
    Creation Date:
        28-Nov-1999
        
    Modification History:
        05-Mar-2002  dws
            Multiple modifications to allow code to function on Netscape 6+ and IE 5.5+
			browsers.  Brought code up to standards.  Changed header to CeleritasWorks.

*/
var layerInfo = new Array();

	//
    // Create a DHTML layer
	//
function createLayer(name, left, top, width, height, visible, overflow, content) {
	var layer;
	if ( is.ns4 ) {
	    document.writeln('<layer id="' + name + '" overflow=' + ((overflow) ? 'visible' : 'hidden') + ' pagex=' + left + ' pagey=' + top + ' width=' + width + ' height=' + height +  ' visibility=' + (visible ? '"show"' : '"hide"') +  '>');
	    document.writeln('<layer id="' + name + '" style="position:absolute;"' + ' left=' + left + ' top=' + top + ' width=' + width + ' height=' + height +  ' visibility=' + (visible ? '"show"' : '"hide"') + ' clip="'+left+','+top+','+width+','+height +  '">');
	    document.writeln(content);
	    document.writeln('</layer>');
	    layer.width = width;
	    layer.height = height;
	}
	else if ( is.DOM ) {
//	    document.writeln('<div id="' + name + '" style="position:absolute; overflow: ' + ((overflow) ? 'visible' : 'none') + '; left:' + left + 'px; top:' + top + 'px; width:' + width + 'px; height:' + height + 'px;' + ' visibility:' + (visible ? 'visible;' : 'hidden;') +  ' z-index: 1">');
	    document.writeln('<div id="' + name + '" style="position:absolute; left:' + left + 'px; top:' + top + 'px; width:' + width + 'px; height:' + height + 'px;' + ' visibility:' + (visible ? 'visible;' : 'hidden;') +  '">');
	    document.writeln(content);
	    document.writeln('</div>');
	}
	else if ( document.all ) {
	    document.writeln('<div id="' + name + '" style="position:absolute; overflow: ' + ((overflow) ? 'visible' : 'none') + '; left:' + left + 'px; top:' + top + 'px; width:' + width + 'px; height:' + height + 'px;' + ' visibility:' + (visible ? 'visible;' : 'hidden;') +  '">');
	    document.writeln(content);
	    document.writeln('</div>');
	}
	clipLayer(name, 0, 0, width, height);
}
	//
    // Get the layer object by name.
	//
function getLayer(name) {
	if ( is.ns4 ) {
		var returnLayer = eval('document.'+name);
	    return(returnLayer);
	}
	else if ( is.DOM ) {
		var returnLayer = eval('document.getElementById("'+name+'")');
	    return(returnLayer);
	}
	else if ( document.all ) {
	  	if ( eval('document.all.' + name) != null ) {
		    layer = eval('document.all.' + name + '.style');
		    return(layer);
		} else {
			return(null);
		}
	}
	else {
	    return(null);
	}
}
	//
    // Return the given layer's left coordinate.
	//
function getLayerLeft(name) {
	var layer = getLayer(name);		
	if (layer != null) {
		if ( is.DOM ) {
			return layer.style.left;
		}
		else if ( is.ns4 ) {
			return layer.clip.left;
		}
		else if ( document.all ) {
            return layer.left;
		}
	}
    return null;
}
	//
    // Return the given layer's Top coordinate.
	//
function getLayerTop(name) {
	var layer = getLayer(name);		
	if (layer != null) {
		if ( is.ns4 ) {
			return layer.clip.top;
		} else if ( is.DOM ) {
			return parseInt(layer.style.top);
		} else if ( document.all ) {
        	return layer.top;
		}
	}
    return null;
}
	//
    // Move a layer (specified by name) to a given corrdinate.
	//
function moveLayer(name, x, y) {		
  	var layer = getLayer(name);		
	if (layer != null) {
		if ( is.ns4 ) {
    		layer.moveTo(x, y);
	  	} else if ( is.DOM ) {
    		layer.style.left = x;
   			layer.style.top  = y;
		} else if ( document.all ) {
    		layer.left = x;
   			layer.top  = y;
	  	}
	}
}
	//
    // Set a given layer's background color.
	//
function setLayerBackgroundColor(name, color) {		
  	var layer = getLayer(name);		
	if ( layer != null ) {
		if ( is.ns4 ) {
    		layer.bgColor = color;
	    } else if ( is.DOM ) {
    		layer.style.backgroundColor = color;
		} else if ( document.all ) {
    		layer.backgroundColor = color;
		}
	}
}
	//
    // Make a given layer invisible.
	//
function hideLayer(name) {		
  	var layer = getLayer(name);		
	if ( layer != null ) {
	  	if ( is.ns4 ) {
    		layer.visibility = "hide";
		} else if ( is.DOM ) {
    		layer.style.visibility = "hidden";
		} else if ( document.all ) {
   			 layer.visibility = "hidden";
		}
	}
}
	//
    // Make a given layer visible.
	//
function showLayer(name) {		
  	var layer = getLayer(name);		
	if ( layer != null ) {
	  	if ( is.ns4 ) {
    		layer.visibility = "show";
		}
	  	else if ( is.DOM ) {
    		layer.style.visibility = "visible";
		}
		else if ( document.all ) 
   			layer.visibility = "visible";
	}
}
	//
    // Crop a given layer to a new clipping rectangle.
	//
function clipLayer(name, clipleft, cliptop, clipright, clipbottom) {
	var layer = getLayer(name);		
	if ( layer != null ) {
		if ( is.ns4 ) {
			layer.clip.left   = clipleft;
			layer.clip.top    = cliptop;
		    layer.clip.right  = clipright;
			layer.clip.bottom = clipbottom;
		}
		else if ( is.DOM ) {
			layer.style.clip = 'rect(' + cliptop + ' ' +  clipright + ' ' + clipbottom + ' ' + clipleft +')';
		}
		else if ( document.all ) {
			layer.clip = 'rect(' + cliptop + ' ' +  clipright + ' ' + clipbottom + ' ' + clipleft +')';
		}
	}
}
	//
    // Replace a layer's content with new content.
	//
function replaceLayerContent(name, content) {
	if ( is.ns4 ) {
		var layer = getLayer(name);
		if ( layer != null ) {
			layer.document.open();
			layer.document.writeln(content);
			layer.document.close();
		}
	} else if ( is.ns ) {
		var layer = eval('document.getElementById("'+name+'")');
		if ( layer != null ) {
			layer.innerHTML = content;
		}
	} else if ( document.all ) {
		if ( eval("document.all." + name) != null ) {
			content = content.replace(/\'/g,"\\'");
			var str = "document.all." + name + ".innerHTML = '" + content + "'";
			eval(str);
		}
	}
}
	//
    // Establish mouse event handlers for a given layer.
	//
function setMouseHandlers(layerName, mOver, mOut, mMove, mDown, mUp) {
    var layer = getLayer(layerName);        
		//
    	// Flag the capture of specific events for Netscape.
		//
	if ( is.ns ) {
        layer.captureEvents(Event.MOUSEOVER | Event.MOUSEOUT | Event.MOUSEMOVE | Event.MOUSEDOWN | Event.MOUSEUP);
	}
		//
        // Establish the mouse handling routines.  Because of the difference in the
        // document object model between Netscape and IE the must be done conditionally
        // based on the browser type.
		//
    if ( is.ns ) {
    
        layer.onmouseover = mOver;
        layer.onmouseout  = mOut;
	    layer.onmousemove = mMove;
	    layer.onmousedown = mDown;
	    layer.onmouseup   = mUp;

    }
    else if ( is.ie ) {
    
        document.onmouseover = mOver;
        document.onmouseout  = mOut;
	    document.onmousemove = mMove;
	    document.onmousedown = mDown;
	    document.onmouseup   = mUp;

    }
		//
        // Save some of the layer's attributes for future reference.
		//
    layerInfo.tagName     = layerName;                
    layerInfo.onmouseover = mOver;
    layerInfo.onmouseout  = mOut;
    layerInfo.onmousemove = mMove;
    layerInfo.onmousedown = mDown;
    layerInfo.onmouseup   = mUp;
    layerInfo.vLock       = false;
    layerInfo.hLock       = false;    
}