/*

    Facility:
        Celeritas Technologies General (ct)
            Copyright 1999 Celeritas Technologies, LLC

    Title:
        ctGeometry

    Abstract:
        This module contains a collection of common Javascript shape (geometry) functions.
        
        Requires: ctListCommon.js

    Author:
        Scott A. Evans (sae)
        
    Creation Date:
        28-Nov-1999
        
    Modification History:
        dd-mmm-yyyy (iii)
            Description of change.

*/

function Polygon(coordList) {

    this.coords = new List(0);
      
    if (coordList != null) {
        this.coords.addAll(coordList, ',');
        this.pairList = _polyBuidPairs(this.coords);
    }

        // Establish the objects methods.  
    this.contains  = _polyContains;
    this.getWidth  = _polyGetWidth;
    this.getHeight = _polyGetHeight;
    
        // Set the polygon's properties.
    this.size = Math.floor(this.coords.getSize() / 2);
    this.width = _polyCalcWidth();
    this.height = _polyCalcHeight();
    
        // Build a shape matrix used be the contains function.
    this.matrix = _polyBuildShapeMatrix(this);
    
} 

function _polyContains() {

}

function _polyGetWidth() {
    return this.width;
}

function _polyGetHeight() {
    return this.height;
}

    // Calculate the polygon's overall width.
function _polyCalcWidth() {
    var polyPairs = this.coords.pairList;
    var i;
    var x0 = 999999;  // Highest X coordinate (right most)
    var x1 = -999999; // Lowest X coordinate (left most)
        
    for ( i = 0; i < this.size; i++ ) {
        if ( polyPairs[i].x < x0 ) {
            x0 = polyPairs[i].x;
        }
        if ( polyPairs[i].x > x1 ) {
            x1 = polyPairs[i].x;
        }
    }
    
    return Math.abs(x0 - x1);
    
}

    // Calculate the polygon's overall height.
function _polyCalcWidth() {
    var polyPairs = this.coords.pairList;
    var i;
    var y0 = 999999;  // Highest Y coordinate (bottom most)
    var y1 = -999999; // Lowest Y coordinate (top most)
        
    for ( i = 0; i < this.size; i++ ) {
        if ( polyPairs[i].y < y0 ) {
            y0 = polyPairs[i].y;
        }
        if ( polyPairs[i].y > y1 ) {
            y1 = polyPairs[i].y;
        }
    }
    
    return Math.abs(y0 - y1);
    
}

function _polyBuidPairs(coordList) {
    var pairList = new Array();
    var i;
    
    for ( i = 0; i < coordList.getSize; i += 2 ) {
        pairList.x = coordList.getAt(i);
        pairList.y = coordList.getAt(i+1);
    }
    
    return pairList;   
}

    // Build a matrix or grid representing the polygon's shape.
function _polyBuildShapeMatrix(polygon) {
    var matrix = new Array(polygon.width * polygon.height);
    var i;
    
    for ( i = 0; i < polygon.size; i++ ) {
        if ( polygon.pairList[i].x 
        matrix[i] = 
    }
    
}