/*

    Facility:
        Celeritas Technologies General (ct)
            Copyright 2000 Celeritas Technologies, LLC

    Title:
        ctDateValidate.js

    Abstract:
        This module contains routines that can be used to validate a date field
    Author:
        Todd R. Smith (trs)
        
    Creation Date:
        22-Aug-2000
        
    Modification History:
        14-Sep-2000 (trs)
            Added the functionality to validate hour, minute and seconds and to check
			a date of any format that contains a format sequence of the following
				yyyy for Year
				MM for zero padded Month
				MMM for Month of the year (e.g. "JAN", "FEB", etc.)
				DD for zero padded day of the month
				dd for Day
				HH for hour
				mm for minute
				ss for second
	
        23-Feb-2001 (djc)
            Added function CT_validateDateWithFocus() that will focus back on the
            calling textbox. 
			
		29-Mar-2001	sae
			Added support for validation of a 3-character month abbreviation and 
			validation using a day format of "DD" in addtion to "dd".

*/

function CT_validateDateWithFocus(form_obj, object_value, format, error_message)
	{

		var bValid = CT_validatedate(object_value, format, error_message)
		if( !bValid ) {
			/*
			 *	Focus back on the form element
			 */
		   form_obj.focus();
		   return false;   
		} else {
		   return true;
		}
	}

function CT_validatedate(object_value, format, error_message)
	{
		if(!CT_checkdate(object_value, format, error_message)){
		   return false;   
		} else {
		   return true;
		}

	}
	
function CT_checkdate(object_value, format, error_message) {
	
	sMonthAbbrevs = "JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC";

    //Returns true if value is a date format or is NULL
    //otherwise returns false	

    if (object_value.length == 0)
        return true;

     //  Returns true if value is a date in the specified format
	//  The available format will have the following compnents:
	//  	 yyyy - Year
	//      MM - Month of the year
	//      MMM - Month of the year (e.g. "JAN", "FEB", etc.)
	//      DD - day of the month
	//      dd - day of the month
	//      HH - 24 hour
	//      mm - minutes
	//      ss - seconds
	//
	//  The HH, mm, and ss terms are optional

		// parse the Month
	var bThreeCharMonth = false;
	var sMonth = "01";
	isplit = format.indexOf("MMM");
	if ( isplit >= 0 ) {
		bThreeCharMonth = true;
	    sMonth = object_value.substring(isplit, isplit + 3);
	} else {
		isplit = format.indexOf("MM");
		if ( isplit >= 0 ) {
		    sMonth = object_value.substring(isplit, isplit + 2);
		}
	}

		// parse the Day
	var sDay = "01";
	isplit = format.indexOf("dd");
	if ( isplit >= 0 ) {
	    sDay = object_value.substring(isplit, isplit + 2);
	} else {
		isplit = format.indexOf("DD");
		if ( isplit >= 0 ) {
		    sDay = object_value.substring(isplit, isplit + 2);
		}
	}

		// parse the Year
	var sYear = "2000";
	isplit = format.indexOf("yyyy");
	if ( isplit < 0 ) {
		isplit = format.indexOf("yy");
		if ( isplit >= 0 ) {
	        alert("Year must be entered as yyyy.  \n" + error_message);
			return false;
		}
	} else {
		sYear = object_value.substring(isplit, isplit + 4);
	}

		// parse the hour
	var sHour = "";
	isplit = format.indexOf("HH");
	if ( isplit >= 0  ) {
		sHour = object_value.substring(isplit, isplit + 2);
	}
	    
		// parse the Minute
	var sMinute = "";
	isplit = format.indexOf("mm");
	if ( isplit >= 0  ) {
		sMinute = object_value.substring(isplit, isplit + 2);
	}
	    
		// parse the Second
	var sSecond = "";
	isplit = format.indexOf("ss");
	if ( isplit >= 0  ) {
		sSecond = object_value.substring(isplit, isplit + 2);
	}

	if ( bThreeCharMonth ) {
		isplit = sMonthAbbrevs.indexOf(sMonth);
		if ( isplit < 0 ) {
	        alert("Month (\"" + sMonth + "\") is invalid.  Expecting 3 Character abbreviation.  \n" + error_message);
			return false;
		} else {
				// If the month abbreviation is valid, convert the month name
				// back into a month number so that the reminder of the standard
				// validation can proceed.
			sMonth = "" + (isplit / 3 + 1);
		}
	}
	
	if (!CT_checkinteger(sMonth)){ //check month
        alert("Month (\"" + sMonth + "\") is invalid.  \n" + error_message);
		return false;
	} else if (!CT_checkrange(sMonth, 1, 12)) { //check month
        alert("Month (\"" + sMonth + "\") is not in the valid range [1..12].  \n" + error_message);
		return false;
	} else if (!CT_checkinteger(sYear)){ //check year
        alert("Year is invalid.  \n" + error_message);
		return false;
	} else if (!CT_checkrange(sYear, 1000, 9999)){ //check year
        alert("Year is not in a valid range [1000..9999].  \n" + error_message);
		return false;
	} else if (!CT_checkinteger(sDay)){ //check day
        alert("Day is invalid.  \n" + error_message);
		return false;
	} else if (!CT_checkday(sYear, sMonth, sDay)){ // check day
        alert("Day is invalid.  \n" + error_message);
		return false;
	} else if (!CT_checkinteger(sHour)){ //check hour
        alert("Hour is invalid.  \n" + error_message);
		return false;
	} else if (!CT_checkrange(sHour, 0, 23)){ //check hour
        alert("Hour is invalid.  \n" + error_message);
		return false;
	} else if (!CT_checkinteger(sMinute)){ //check minute
        alert("Minute is invalid.  \n" + error_message);
		return false;
	} else if (!CT_checkrange(sMinute, 0, 59)){ //check minute
        alert("Minute is invalid.  \n" + error_message);
		return false;
	} else if (!CT_checkinteger(sSecond)){ //check second
        alert("Second is invalid.  \n" + error_message);
		return false;
	} else if (!CT_checkrange(sSecond, 0, 59)){ //check second
        alert("Second is invalid.  \n" + error_message);
		return false;
	} else if ( object_value.length != format.length ) {
		/*
		 *	check the length of the format versus the length of
		 *	the value.
		 */
	   alert("Please format date as: " + format);
	   return false;
	} else {
		return true;
    }
}


function CT_checkday(checkYear, checkMonth, checkDay)
    {

	maxDay = 31;

	if (checkMonth == 4 || checkMonth == 6 ||
			checkMonth == 9 || checkMonth == 11)
		maxDay = 30;
	else
	if (checkMonth == 2)
	{
		if (checkYear % 4 > 0)
			maxDay =28;
		else
		if (checkYear % 100 == 0 && checkYear % 400 > 0)
			maxDay = 28;
		else
			maxDay = 29;
	}

	return CT_checkrange(checkDay, 1, maxDay); //check day
    }



function CT_checkinteger(object_value)
    {
    //Returns true if value is a number or is NULL
    //otherwise returns false	

    if (object_value.length == 0)
        return true;

    //Returns true if value is an integer defined as
    //   having an optional leading + or -.
    //   otherwise containing only the characters 0-9.
	var decimal_format = ".";
	var check_char;

    //The first character can be + -  blank or a digit.
	check_char = object_value.indexOf(decimal_format)
    //Was it a decimal?
    if (check_char < 1)
	return CT_checknumber(object_value);
    else
	return false;
    }



function CT_numberrange(object_value, min_value, max_value)
    {
    // check minimum
    if (min_value != null)
	{
        if (object_value < min_value)
		return false;
	}

    // check maximum
    if (max_value != null)
	{
	if (object_value > max_value)
		return false;
	}
	
    //All tests passed, so...
    return true;
    }



function CT_checknumber(object_value)
    {
    //Returns true if value is a number or is NULL
    //otherwise returns false	

    if (object_value.length == 0)
        return true;

    //Returns true if value is a number defined as
    //   having an optional leading + or -.
    //   having at most 1 decimal point.
    //   otherwise containing only the characters 0-9.
	var start_format = " .+-0123456789";
	var number_format = " .0123456789";
	var check_char;
	var decimal = false;
	var trailing_blank = false;
	var digits = false;

    //The first character can be + - .  blank or a digit.
	check_char = start_format.indexOf(object_value.charAt(0))
    //Was it a decimal?
	if (check_char == 1)
	    decimal = true;
	else if (check_char < 1)
		return false;
        
	//Remaining characters can be only . or a digit, but only one decimal.
	for (var i = 1; i < object_value.length; i++)
	{
		check_char = number_format.indexOf(object_value.charAt(i))
		if (check_char < 0)
			return false;
		else if (check_char == 1)
		{
			if (decimal)		// Second decimal.
				return false;
			else
				decimal = true;
		}
		else if (check_char == 0)
		{
			if (decimal || digits)	
				trailing_blank = true;
        // ignore leading blanks

		}
	        else if (trailing_blank)
			return false;
		else
			digits = true;
	}	
    //All tests passed, so...
    return true
    }



function CT_checkrange(object_value, min_value, max_value)
    {
    //if value is in range then return true else return false

    if (object_value.length == 0)
        return true;


    if (!CT_checknumber(object_value))
	{
	return false;
	}
    else
	{
	return (CT_numberrange((eval(object_value)), min_value, max_value));
	}
	
    //All tests passed, so...
    return true;
    }
