/*
		Facility:
			SpatialObjects - Geographic Network Management
	        Copyright 2001 Celeritas Technologies, L.L.C.
			
	 	Title:
	   		ctColorFunctions.js
			
		Abstract:
			This file contains various functions related to the
			use of color in user interfaces.
	      
	 	Author:
			Robert L. Marshall/Celeritas Technologies, LLC
	
	  	Creation Date:
	 		27-Mar-2001
	
		Modification History:
			10-Apr-2002		dws
				Modified the path name to the ctColorSelect.html file to match
				the new directory structure.

		Dependencies:
			ctPopUpDialog.js
			ctColorSelect.html
*/
		//
		// The function displayColorSelector causes the Color Selector
		// window to appear at specified top and left screen
		// coordinates.  The arguments in the function call are as follows:
		//
		// 		psColor			A string representing the default color
		//						that is to be initially displayed
		// 						in the Color Selector window as the
		//						selected color.	 psColor must be a
		//						string in one of the following formats:
		//							"HHHHHH"		(six hexadecimal
		//											digits, 0-F)
		//
		//							"(n,n,n)"		(a triple of decimal
		//											numbers, 0-255, with
		//											leading spaces allowed)
		//
		//							""				(empty string)
		//
		//							null			(a null value)
		//						
		//		pnLeftOffset	The desired screen X coordinate (which
		//						the showPopUp function may modify based
		//						on the window width) of the window.
		//
		//		pnTopOffset		The screen Y coordinate of the window.
		//
		//		pbUseModal		A Boolean value (true, false) specifying
		//						that the modal window option (a function
		//						available in Microsoft Internet Explorer 4
		//						and later) is enabled and to be used when
		//						the browser allows its use.
		//
		//
		// This function is heavily dependent upon the file
		// ctColorSelect.html.
		// Also, in order to use this function, the window that calls this
		// function must include both the function call and a function named
		// specifically setColor, which serves as the completion routine
		// to which the Color Selector passes control when the selected
		// color is returned from the Color Selector.
		//
		// In the window that calls the function displayColorSelector,
		// the function call must be in the following format:
		//
		// 		displayColorSelector(sInitialColorStr, nLeftOffset,
		//				nTopOffset, bUseModal
		//				[, comma-delimited arguments (maximum of 10)]
		//				);
		//
		// Also in the window that calls the function displayColorSelector,
		// the completion routine setColor must be in the following format:
		//
		//			function setColor(psColor
		//					[, comma-delimited arguments (maximum of 10)]) {
		//
		//				[function statements as desired]
		//
		//			}
		//
		// As shown above, in the argument list for the call to
		// function displayColorSelector,
		// following the parameter bUseModal, the user can append
		// comma-delimited arguments (maximum of 10) that the user
		// wishes to pass to the completion function setColor.
		// These arguments are forwarded directly to the completion
		// function setColor.  If more than 10 arguments need to be
		// passed to the completion function setColor, the function
		// displayColorSelector and the file called via the showPopUp
		// functions below can be modified to increase the number of
		// elements in the array arArgsToCompletionRoutine.
		//
		// Also, as shown above, the body of the function setColor
		// can contain whatever function statements are required, making
		// use of the returned color psColor (as well as any of the
		// comma-delimited arguments that were listed in the call to
		// function displayColorSelector).  The comma-delimited arguments
		// are returned from the Color Selector routine to the
		// function setColor in the same order as they were passed to
		// the function displayColorSelector.
		//
		//
		//
		// Define global variables for the function displayColorSelector
		// (to enable access to them by the pop up window created
		// in the function displayColorSelector).
		//
	var rWinObj = null;
	var arArgsToCompletionRoutine = null;
	var arArgsToWindow = null;
		//
	function displayColorSelector (psColor, pnLeftOffset,
			pnTopOffset, pbUseModal) {
			//
			// Initialize the number of arguments contained in this
			// function call (for calculations below).
			//
		var nInitialArgs = 4;
		var nMaxNumOfArgsToCompletionRoutine = 10;
			//
			// Place into an array the comma-delimited arguments to be
			// forwarded to the completion function setColor.
			//
		var nNumOfArgsToCompletionRoutine = arguments.length - nInitialArgs;
		arArgsToCompletionRoutine = new Array(nNumOfArgsToCompletionRoutine);
		for (var nArgIndex = 0; nArgIndex < nNumOfArgsToCompletionRoutine;
				nArgIndex++) {
			arArgsToCompletionRoutine[nArgIndex] =
					arguments[nInitialArgs + nArgIndex];
		}
		for (nArgIndex = nNumOfArgsToCompletionRoutine;
				nArgIndex < nMaxNumOfArgsToCompletionRoutine;
				nArgIndex++) {
			arArgsToCompletionRoutine[nArgIndex] = null;	
		}
			//
			// Create an array to contain the initial color (at a
			// minimum), and any other arguments needing to be passed
			// to the window (for processing in the window).
			//
		arArgsToWindow = new Array(1);
		arArgsToWindow[0] = psColor;
			//
			// If the preference is for the pop up window to be modal,
			// verify that the browser supports the function showModalDialog
			// (available for Internet Explorer 4 and later).  The strict
			// equal comparison operator (===) prevents anything but a strict
			// true from changing the default of preferring the window
			// not to be modal.
			//
		var sName = navigator.appName;
		var sVer = navigator.appVersion;
		if ((pbUseModal === true) &&
				(sName == "Microsoft Internet Explorer") &&
				(sVer.substr(sVer.indexOf("MSIE") + 5, 1) >= 4)) {
				//
				// Create the modal window, and assign the resulting
				// color to a variable.
				//
				// Due to differences in the display of a non-modal window
				// versus this modal window, the window height for this
				// modal window is greater than that of a non-modal
				// window.
				//
			nWindowHeight = 395;
			
			var sReturnColor = showPopUp("../CeleritasCommon/ctColorSelect.html",
					"ctColorSelect", pnLeftOffset, pnTopOffset,
					270, nWindowHeight,
					false, false, false, true, arArgsToWindow);
				//
				// If the color value returned from the modal window
				// is not null, call the function setColor, passing
				// to it the returned color value and the comma-delimited
				// list of arguments originally received into this
				// function displayColorSelector.
				// Otherwise, the color value returned from the modal
				// window is null (such as by closing the window via the
				// window's "X" button or Cancel button, rather than
				// via the Save button), so do not call the function setColor.
				//
			if (sReturnColor != null) {

				setColor(sReturnColor,
						arArgsToCompletionRoutine[0],
						arArgsToCompletionRoutine[1],
						arArgsToCompletionRoutine[2],
						arArgsToCompletionRoutine[3],
						arArgsToCompletionRoutine[4],
						arArgsToCompletionRoutine[5],
						arArgsToCompletionRoutine[6],
						arArgsToCompletionRoutine[7],
						arArgsToCompletionRoutine[8],
						arArgsToCompletionRoutine[9]);			
			}

		} else {

				//
				// Create the non-modal window, while assigning a handle
				// (rWinObj) to the window.  In the non-modal window, use the
				// window.opener object to access the arArgsToWindow array
				// and the arArgsToCompletionRoutine array.  Then, also in
				// the non-modal window, call the function setColor,
				// passing to it the final selected color and the
				// comma-delimited list of arguments originally
				// received into this function (and now contained in the
				// array arArgsToCompletionRoutine).
				//
				// Due to differences in the display of a modal window
				// versus this non-modal window, the window height for this
				// non-modal window is less than that of a modal
				// window.
				//
			nWindowHeight = 370;
		
			rWinObj = showPopUp("../CeleritasCommon/ctColorSelect.html",
					"ctColorSelect", pnLeftOffset, pnTopOffset,
					270, nWindowHeight,
					false, false, false, false, null);
		}
	}
	