/*

    Facility:
        Celeritas Technologies General (ct)
            Copyright 1999 Celeritas Technologies, LLC

    Title:
        ctBrowserSensing.js

    Abstract:
        This module contains a routine that catalogs the browser type and various
        other browser specific attributes.

    Author:
        Celeritas Technologies
        
    Creation Date:
        28-Nov-1999
        
    Modification History:
        21-Feb-2002  dws
            Updated to handle the new DOM-enabled browsers like Netscape 6+ and IE 5.5+.

*/

    // Set up boolian variables to record the browser type.
var isNS4 = 0;
var isIE4 = 0;
var isNew = 0;

is = new BrowserCheck();

function BrowserCheck() {

    /* Determines the browser name and browser version */
	var ieVersion = 4;
	var userAgent = navigator.userAgent;
    var brow = navigator.appName;

	if ( brow == "Netscape" ) {
        this.brow = "NS";
	} else if ( brow == "Microsoft Internet Explorer" ) {
        this.brow = "IE";
		var testVal = (navigator.appVersion).indexOf('MSIE');
		var testStr = (navigator.appVersion).substring(testVal+4);
		ieVersion = parseFloat(testStr);
	} else {
        this.brow = brow;
	}

        // Assign variable depending on the browser
	this.version = navigator.appVersion;
	this.ver = parseInt(this.version);
	this.ns  = (this.brow == "NS" && this.ver >= 4);
	this.ns4 = (this.brow == "NS" && this.ver == 4);
	this.ns5 = (this.brow == "NS" && this.ver == 5);
	this.ie  = (this.brow == "IE" && this.ver >= 4);
	this.ie4 = (this.version.indexOf('MSIE 4') > 0);
	this.ie5 = (this.version.indexOf('MSIE 5') > 0);
	this.min = (this.ns || this.ie);
	this.DOM = ( (userAgent.indexOf('Gecko') > 0) || (ieVersion >= 5.5) );
    
        // Set variables used by other applications using a different convention.
    isNS4 = this.ns4;
    isIE4 = this.ie4;
    isNew = (this.ie5 || this.min);
    
}

