/*

    Facility:
        Celeritas Technologies General (ct)
            Copyright 1999 Celeritas Technologies, LLC

    Title:
        ctBehavior.js

    Abstract:
        This module contains a collection of Javascript layer behavior functions
        adapted from the JavaScript DHTML Utilities originally authoried by Michael Bostock
        of Netscape Communications Corporation.

    Author:
        Scott A. Evans (sae)
        
    Creation Date:
        28-Nov-1999
        
    Modification History:
        dd-mmm-yyyy (iii)
            Description of change.

*/
var ieLayer;
var nsLayer;
var _targetLayer = new Array();

var isNav4, isIE4;
if (parseInt(navigator.appVersion.charAt(0)) >= 4) {
  isNav4 = (navigator.appName == "Netscape") ? true : false;
  isIE4 = (navigator.appName.indexOf("Microsoft") != -1) ? true : false;
}

///////////////////////////////////////////////////////////////////////
// Helper functions used by this library

// Fixed by Tomislav Tustonic -- thanks!
function _contains(outerlayer, innerlayer) {
  var iL, iT, iW, iH;
  var oL, oT, oW, oH;
  iL = (isNav4)? innerlayer.pageX : innerlayer.offsetLeft;
  iT = (isNav4)? innerlayer.pageY : innerlayer.offsetTop;
  iW = (isNav4)? innerlayer.clip.width : innerlayer.style.pixelWidth;
  iH = (isNav4)? innerlayer.clip.height : innerlayer.style.pixelHeight;
  oL = (isNav4)? outerlayer.pageX : outerlayer.offsetLeft;
  oT = (isNav4)? outerlayer.pageY : outerlayer.offsetTop;
  oW = (isNav4)? outerlayer.clip.width : outerlayer.style.pixelWidth;
  oH = (isNav4)? outerlayer.clip.height : outerlayer.style.pixelHeight;
  if(iL < oL) return false;
  if(iT < oT) return false;
  if(iL + iW > oL + oW) return false;
  if(iT + iH > oT + oH) return false;
  return true;
}

///////////////////////////////////////////////////////////////////////
// The Behavior Object

function Behavior(drag) {
  this.mouseDownAction = null;
  this.mouseUpAction = null;
  this.mouseMoveAction = null;
  this.mouseOverAction = null;
  this.mouseOutAction = null;
  this.draggable = drag;
  this.setAction = setAction;
  this.applyBehavior = applyBehavior;
  this.hLock = false;
  this.vLock = false;
  this.useBounds = false;
  this.setBounds = setBounds;
  this.removeBounds = removeBounds;
  this.bounds = false;
  this.containers = false;
  this.addContainer = addContainer;
  this.update = _updateAll;
}

///////////////////////////////////////////////////////////////////////
// Behaviors Object: update

function _updateAll(doc) {
  if(!doc) doc = document;
  if(isNav4) {
    for(var i = 0; i < doc.layers.length; i++) {
      if(doc.layers[i].document.layers)
	this.update(doc.layers[i].document);
      if(doc.layers[i].behavior &&
	 doc.layers[i].behavior == this)
	this.applyBehavior(doc.layers[i]);
    }
  } else if(isIE4) {
    for(var i = 0; i < doc.all.length; i++) {
      if ( doc.all[i].behavior &&
	       doc.all[i].behavior == ieLayer ){
    	ieLayer.applyBehavior(doc.all[i]);
      }
    }
  }
}

///////////////////////////////////////////////////////////////////////
// Behaviors Object: containers

function addContainer(layer) {
  if(!this.containers) this.containers = new Array();
  this.containers[this.containers.length] = layer;
}

function removeContainer(layer) {
  for(var i = 0; i < this.containers.length; i++)
    if(this.containers[i] == layer)
      this.containers[i] = null;
}

///////////////////////////////////////////////////////////////////////
// Behaviors Object: setting bounds for dragging

function setBounds(l, r, t, b) {
  this.useBounds = true;
  if(this.bounds == false) this.bounds = new Array(4);
  this.bounds[0] = l;
  this.bounds[1] = r;
  this.bounds[2] = t;
  this.bounds[3] = b;
}

function removeBounds() {
  this.useBounds = false;
}

///////////////////////////////////////////////////////////////////////
// Behaviors Object: setting action-event pairs

function setAction(action, func) {
  eval('switch(action) {'+
    'case "MOUSEDOWN": this.mouseDownAction = func; break;'+
    'case "MOUSEMOVE": this.mouseMoveAction = func; break;'+
    'case "MOUSEUP":   this.mouseUpAction = func;   break;'+
    'case "MOUSEOVER": this.mouseOverAction = func; break;'+
    'case "MOUSEOUT":  this.mouseOutAction = func;  break;'+
    'case "CONTAINERPUSH": this.containerPushAction = func; break;'+
    'case "CONTAINERPULL": this.containerPullAction = func; break;'+
  '}');
}

function setDraggable(dragState) {
    this.draggable = dragState;
}

///////////////////////////////////////////////////////////////////////
// Behaviors Object: cross-browser helpers

function isShift(e) {
  if(window.event) return window.event.shiftKey;
  else return (e.modifiers & Event.SHIFT_MASK);
}

function isAlt(e) {
  if(window.event) return window.event.altKey;
  else return (e.modifiers & Event.ALT_MASK);
}

function isControl(e) {
  if(window.event) return window.event.ctrlKey;
  else return (e.modifiers & Event.CONTROL_MASK);
}

///////////////////////////////////////////////////////////////////////
// Behaviors Object: applyBehavior

function applyBehavior(layer) {
  layer.behavior = this;
  layer.draggable = this.draggable;
  if(layer.captureEvents) {  
    //layer.captureEvents(Event.MOUSEDOWN|Event.MOUSEMOVE|Event.MOUSEUP|Event.MOUSEOVER|Event.MOUSEOUT);
    window.captureEvents(Event.MOUSEDOWN|Event.MOUSEMOVE|Event.MOUSEUP);
    window.onmousedown = _handleMouseDown;
    window.onmousemove = _handleMouseMove;
    window.onmouseup   = _handleMouseUp;
    window.mouseDownAction = this.mouseDownAction;
    window.mouseUpAction = this.mouseUpAction;
    window.mouseMoveAction = this.mouseMoveAction;
    nsLayer = layer;
  }
  if(isIE4) {
    document.onmousedown = _handleMouseDown;
    document.onmousemove = _handleMouseMove;
    document.onmouseup   = _handleMouseUp;
    //document.onmouseover = _handleMouseOver;
    //document.onmouseout  = _handleMouseOut;
    ieLayer = layer;
  }
  
      // Save any existing Window or Document mouse handlers to restore when the menu mouse actions are complete.    
  document.currDocOnMouseDown = document.onmousedown;
  document.currDocOnMouseUp   = document.onmouseup;
  document.currDocOnMouseMove = document.onmousemove;
  document.currDocOnMouseOver = document.onmouseover;
  document.currDocOnMouseOut  = document.onmouseout;
  window.currWinOnMouseDown   = window.onmousedown;
  window.currWinOnMouseUp     = window.onmouseup;
  window.currWinOnMouseMove   = window.onmousemove;
  window.currWinOnMouseOver   = window.onmouseover;
  window.currWinOnMouseOut    = window.onmouseout;

  //layer.onmousedown = _handleMouseDown;
  //layer.onmousemove = _handleMouseMove;
  //layer.onmouseup = _handleMouseUp;
  //layer.onmouseover = _handleMouseOver;
  //layer.onmouseout = _handleMouseOut;
  layer.containers = this.containers;
  layer.containerPushAction = this.containerPushAction;
  layer.containerPullAction = this.containerPullAction;
  layer.vLock = this.vLock;
  layer.hLock = this.hLock;
  layer.bounds = new Array(4);
  layer.bounds[0] = this.bounds[0];
  layer.bounds[1] = this.bounds[1];
  layer.bounds[2] = this.bounds[2];
  layer.bounds[3] = this.bounds[3];
  layer.useBounds = this.useBounds;
  layer.mouseDownAction = this.mouseDownAction;
  layer.mouseUpAction = this.mouseUpAction;
  layer.mouseMoveAction = this.mouseMoveAction;
  layer.mouseOverAction = this.mouseOverAction;
  layer.mouseOutAction = this.mouseOutAction;
}

///////////////////////////////////////////////////////////////////////
// Behaviors Object: event handlers with routing/canceling

function _handleMouseOver(e) {
  if(isNav4) {
    _targetLayer.layer = this;
    if(e.target != this) {
      routeEvent(e);
      return;
    }
  } else {
     _targetLayer.layer = ieLayer;
    if(window.event.srcElement == this &&
       window.event.srcElement.tagName == "DIV")
      window.event.cancelBubble = true;
    else if(window.event.srcElement == ieLayer) return;
  }
  if(_targetLayer.layer.mouseOverAction) _targetLayer.layer.mouseOverAction(e, "mouseover");
}

function _handleMouseOut(e) {
  if(isNav4) {
    if(e.target != this) {
      _targetLayer.layer = this;
      routeEvent(e);
      return;
    }
  } else {
     _targetLayer.layer = ieLayer;
    if(window.event.srcElement == this &&
       window.event.srcElement.tagName == "DIV")
      window.event.cancelBubble = true;
    else if(window.event.srcElement == ieLayer) return;
  }
  if(_targetLayer.layermouseOutAction) _targetLayer.layer.mouseOutAction(e, "mouseout");
}

///////////////////////////////////////////////////////////////////////
// Behaviors Object: built-in dragging handlers

function _handleMouseDown(e) {

  if(isNav4) {
      //_targetLayer.layer = this;
      _targetLayer.layer = nsLayer;
      routeEvent(e);
      if(e.handled) return;
  } 
  else {
      window.event.cancelBubble = true;
     _targetLayer.layer = ieLayer;
  }
  
  if(_targetLayer.layer.mouseDownAction) {
	//if (isIE4) window.status = 'Calling mouswDown ...';
    _targetLayer.layer.mouseDownAction(e, "mousedown");
  }
  if(!_targetLayer.layer.draggable) return;
  if(_targetLayer.layer.containers) {
    _targetLayer.layer.wasContained = false;
    for(var i = 0; i < _targetLayer.layer.containers.length; i++) {
        if(_contains(_targetLayer.containers[i], _targetLayer)) {
	        _targetLayer.wasContained = _targetLayer.containers[i];
	        break;
        }
    }
  }
  if(isNav4) {
    _targetLayer.layer.offsetX = e.pageX - _targetLayer.layer.left;
    _targetLayer.layer.offsetY = e.pageY - _targetLayer.layer.top;
  } 
//  else {window.event.offsetX
  else {
    _targetLayer.layer.offsetX = window.event.offsetX;
    _targetLayer.layer.offsetY = window.event.offsetY;
  }
  _targetLayer.indrag = true;
  if(isNav4) e.handled = true;
  return;
}

function _handleMouseMove(e) {
  var ret = false;
  if ( isNav4 ) {
    //_targetLayer.layer = this;
    _targetLayer.layer = nsLayer;
    routeEvent(e);
    if(e.handled) {
        return false;
    }
  } 
  else {
    _targetLayer.layer = ieLayer;
    window.event.cancelBubble = true;
  }
  if(_targetLayer.layer.mouseMoveAction) {
    ret = _targetLayer.layer.mouseMoveAction(e, "mousemove");
  }
  if(!_targetLayer.layer.draggable) return ret;
  if(!_targetLayer.indrag) return true;
  if(!_targetLayer.layer.vLock) {
    var dstY;
    if(isNav4) {
      dstY = (e.pageY - _targetLayer.layer.offsetY);
      if((_targetLayer.layer.useBounds &&
	     (dstY >= _targetLayer.layer.bounds[2]) &&
	     (dstY + _targetLayer.layer.clip.height <= _targetLayer.layer.bounds[3])) || !_targetLayer.layer.useBounds) {
        	_targetLayer.layer.top = dstY;
      }
      else if (_targetLayer.layer.useBounds) {
	    if (dstY < _targetLayer.layer.bounds[2])
	        _targetLayer.layer.top = _targetLayer.layer.bounds[2];
	    else _targetLayer.layer.top = _targetLayer.layer.bounds[3] -
	       _targetLayer.layer.clip.height;
      }
    }
    else {
      dstY = (window.event.clientY - _targetLayer.layer.offsetY);
      if ((_targetLayer.layer.useBounds &&
	      (dstY >= _targetLayer.layer.bounds[2]) &&
	      (dstY + _targetLayer.layer.pixelHeight <= _targetLayer.layer.bounds[3])) || !_targetLayer.layer.useBounds) {
        	_targetLayer.layer.pixelTop = dstY;
      }
      else if (_targetLayer.layer.useBounds) {
	    if (dstY < _targetLayer.layer.bounds[2]) {
	        _targetLayer.layer.pixelTop = _targetLayer.layer.bounds[2];
	    }
        else {
            _targetLayer.layer.pixelTop = _targetLayer.layer.bounds[3] - _targetLayer.layer.style.pixelHeight;
        }
      }
    }
  }
  if(!_targetLayer.layer.hLock) {
    var dstX;
    if(isNav4) {
      dstX = (e.pageX - _targetLayer.layer.offsetX);
      if((_targetLayer.layer.useBounds &&
	  (dstX + _targetLayer.layer.clip.width <= _targetLayer.layer.bounds[1]) &&
	  (dstX >= _targetLayer.layer.bounds[0])) ||
	 !_targetLayer.layer.useBounds)
	_targetLayer.layer.left = dstX;
      else if(_targetLayer.layer.useBounds) {
	if(dstX < _targetLayer.layer.bounds[0])
	  _targetLayer.layer.left = _targetLayer.layer.bounds[0];
	else _targetLayer.layer.left = _targetLayer.layer.bounds[1] -
	       _targetLayer.layer.clip.width;
      }
    } else {
      dstX = (window.event.clientX - _targetLayer.layer.offsetX);
      if((_targetLayer.layer.useBounds &&
	  (dstX + _targetLayer.layer.pixelWidth <= _targetLayer.layer.bounds[1]) &&
	  (dstX >= _targetLayer.layer.bounds[0])) ||
	 !_targetLayer.layer.useBounds)
	_targetLayer.layer.pixelLeft = dstX;
      else if(_targetLayer.layer.useBounds) {
	if(dstX < _targetLayer.layer.bounds[0])
	  _targetLayer.layer.pixelLeft = _targetLayer.layer.bounds[0];
	else _targetLayer.layer.pixelLeft = _targetLayer.layer.bounds[1] -
	       _targetLayer.layer.pixelWidth;
      }
    }
  }
  if(isNav4) e.handled = true;
  return false;
}

function _handleMouseUp(e) {
  if(isNav4) {
      //_targetLayer.layer = this;
      _targetLayer.layer = nsLayer;
      routeEvent(e);
      if(e.handled) return;
  } 
  else {
      _targetLayer.layer = ieLayer;
      window.event.cancelBubble = true;
  }
  if(!_targetLayer.layer) {
    return;
  }
  if(_targetLayer.layer.mouseUpAction) {
    _targetLayer.layer.mouseUpAction(e, "mouseup");
  }
  if(!_targetLayer.layer.draggable) return;
  if(_targetLayer.layer.containers) {
    _targetLayer.layer.isContained = false;
    for(var i = 0; i < _targetLayer.layer.containers.length; i++) {
      if(_contains(_targetLayer.layer.containers[i], _targetLayer.layer)) {
	_targetLayer.layer.isContained = _targetLayer.layer.containers[i];
      }
    }
    if(_targetLayer.layer.wasContained != _targetLayer.layer.isContained) {
      if(_targetLayer.layer.containerPullAction && _targetLayer.layer.wasContained)
	_targetLayer.layer.containerPullAction(_targetLayer.layer.wasContained, "containerpull");
      if(_targetLayer.layer.containerPushAction && _targetLayer.layer.isContained)
	_targetLayer.layer.containerPushAction(_targetLayer.layer.isContained, "containerpush");
    }
  }
  _targetLayer.indrag = false;
  _targetLayer.layer = null;
  if(isNav4) e.handled = true;
  return;
}

///////////////////////////////////////////////////////////////////////
// Behaviors Object: the end

